<?php
namespace Hdll\Services\Common\Exception;

use Swoft\Exception\Exception;

class BaseException extends Exception
{
    // HTTP 状态码 404,200
    public $code = 500;

    // 错误具体信息
    public $message = '服务器异常';

    // 业务错误码
    public $errorCode = -1;

    public function __construct($params = [])
    {
        if(isset($params['code'])){
            $this->code = $params['code'];
        }

        if(isset($params['msg'])){
            $this->message = $params['msg'];
        }

        if(isset($params['error_code'])){
            $this->errorCode = $params['error_code'];
        }

        parent::__construct($this->message, $this->code);
    }

    public function getErrcode(){
        return $this->errorCode;
    }

}