<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store-settings service
 *
 * @method ResultInterface deferGetSettings(int $storeId)
 * @method ResultInterface deferGetNoticeSwitch(int $storeId)
 */
interface SettingsInterface
{
    /**
     * 获取店铺基础设置项
     * 
     * @Number(name="storeId")
     * @param int $storeId  
     * @return array
     */
    public function getSettings(int $storeId);

    /**
     * 获取消息通知的开关设置项
     * 
     * @Number(name="storeId")
     * @param int $storeId  
     * @return array
     */
    public function getNoticeSwitch(int $storeId);

}