<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Common\Entity;

use Hdll\Services\Auth\Enum\AuthError;
use Hdll\Services\Common\Enum\TestEnum;
use Swoft\App;
use Swoft\Bean\Annotation\Bean;
use Swoft\Core\RequestContext;
use Swoft\Redis\Redis;

/**
 * 用户实体
 * @Bean()
 * @uses      User
 * @version   2017年08月23日
 * @author    stelin <phpcrazy@126.com>
 * @copyright Copyright 2010-2016 Swoft software
 * @license   PHP Version 7.x {@link http://www.php.net/license/3_0.txt}
 */
class User
{
    public function __construct($token='')
    {
    }

    public function getId()
    {
        return $this->getValue('id');
    }

    public function setTestFlag()
    {
        $this->setValue('testFlag', TestEnum::TEST_STORE_ID);
    }

    public function getTestFlag()
    {
        return $this->getValue('testFlag');
    }

    public function getNickname()
    {
        return $this->getValue('nickname');
    }

    public function getStoreId()
    {
        return $this->getValue('storeId');
    }

    public function getHeadImg()
    {
        return $this->getValue('headImg');
    }

    public function getToken()
    {
        return $this->getValue('token');
    }

    public function getIsSeller()
    {
        return $this->getValue('isSeller');
    }

    public function setId($value)
    {
        $this->setValue('id', $value);
    }


    public function setNickname($value)
    {
        $this->setValue('nickname', $value);
    }

    public function setStoreId($value)
    {
        $this->setValue('storeId', $value);
    }

    public function setHeadImg($value)
    {
        $this->setValue('headImg', $value);
    }


    public function setSessionKey($value)
    {
        $this->setValue('sessionKey', $value);
    }

    public function setOpenId($value)
    {
        $this->setValue('openid', $value);
    }


    public function setUnionid($value)
    {
        $this->setValue('unionid', $value);
    }

    public function setReferId($value)
    {
        $this->setValue('referId', $value);
    }

    public function setScope($value)
    {
        $this->setValue('scope', $value);
    }

    public function setToken($value)
    {
        $this->setValue('token', $value);
    }

    public function setIsSeller($value)
    {
        $this->setValue('isSeller', $value);
    }

    public function setSubStoreId($value)
    {
        $this->setValue('subStoreId', $value);
    }

    public function getSubStoreId()
    {
        return $this->getValue('subStoreId')??0;
    }



    public function fill($arr)
    {
        foreach ($arr as $name =>  $value) {
            $methodName = sprintf('set%s', ucfirst($name));
            if (method_exists($this, $methodName)) {
                $this->$methodName($value);
            }
        }
    }


    public function getSessionKey()
    {
        return $this->getValue('sessionKey');
    }

    public function getOpenId()
    {
        return $this->getValue('openid');
    }


    public function getUnionid()
    {
        return $this->getValue('unionid');
    }

    public function getReferId()
    {
        return $this->getValue('referId');
    }

    public function getScope()
    {
        return $this->getValue('scope');
    }

    /**
     * 是否是通过托管的小程序授权
     *
     * @return boolean 如果是托管 返回true
     */
    public function isEntrusted()
    {
        $ent = $this->getValue('entrusted');
        if($ent == 1) {
            return true;
        }
        return false;
    }


    public function initUser($token)
    {
        if ( empty($token) ) {
            return [false,AuthError::GET_TOKEN_ERROR];
        }

        $redis = App::getBean(Redis::class);
        $info = $redis->get("AUTH:".$token);

        if ( empty($info) ) {
            return [false,AuthError::NOT_FOUND_USER];
        }

        $info = json_decode($info, true);
        //$this->fill($info);

        RequestContext::setContextData(['userInfo' => $info]);

        return true;

    }

    private function getValue($key)
    {
        $data = RequestContext::getContextData();

        return $data['userInfo'][$key]??'';
    }

    private function setValue($key, $value='')
    {
        $userInfo = [];
        $userInfo['userInfo'][$key] = $value;
        RequestContext::removeContextDataByChildKey('userInfo', $key);
        RequestContext::setContextData($userInfo);
    }


}
