<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:49
 */
namespace Hdll\Services\Common\Entity;

use Swoft\App;
use Swoft\Db\Bean\Collector\EntityCollector;
use Swoft\Exception\Exception;

class CommonSplitEntity extends CommonEntity
{

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $dbNum = self::getDbNum();
        self::setTableName($dbNum);

    }

    public static function getDb()
    {
        $dbNum = self::getDbNum();
        self::setTableName($dbNum);


        return new static();
    }

    /**
     * 获取数据库id
     * @return int
     * @throws Exception
     */
    private static function getDbNum()
    {
        $user = App::getBean(User::class);

        $store = $user->getStoreId();
        if ( empty($store) ) {
            throw new Exception("店铺id获取失败");
        }

        return  $store % 100;

    }

    private static function setTableName($dbNum)
    {
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        $commentString = $res->getDocComment();
        preg_match('/(?<=Table\(name=").*(?="\))/', $commentString, $matches);
        $tableName = isset($matches[0])?$matches[0]:'';

        EntityCollector::collect(
            static::class,
            new \Swoft\Db\Bean\Annotation\Table(['name' => $tableName.'_'.$dbNum])
        );

    }
}