<?php
namespace Hdll\Services\Common\Exception;

use Swoft\Exception\Exception;

class BaseException extends Exception
{
    // HTTP 状态码 404,200
    public $code = 500;

    // 错误具体信息
    public $message = '服务器异常';

    // 业务错误码
    public $errorCode = -1;

    public function __construct($params)
    {
        if(!is_array($params)){
            return ;
            throw new Exception('参数必须是数组');
        }
        if(array_key_exists('code',$params)){
            $this->code = $params['errorCode'];
        }

        if(array_key_exists('msg',$params)){
            $this->message = $params['msg'];
        }

        if(array_key_exists('errorCode',$params)){
            $this->errorCode = $params['errorCode'];
        }

        parent::__construct($this->message, $this->code);
    }

    public function getErrcode(){
        return  $this->errorCode;
    }

}