<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Notice\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method ResultInterface deferSend(int $storeId, array $sendTypes, array $data, $sendTime, string $redisKey) :bool
 * @method ResultInterface deferCancelSend(string $redisKey):bool
 * @method ResultInterface deferCostumerSend(string $openId, int $oemId = 0);
 */
interface NoticeInterface
{
    /**
     * 参数说明
     *
     * thing.DATA	事物	20个以内字符	可汉字、数字、字母或符号组合
	    number.DATA	数字	32位以内数字	只能数字，可带小数
	    letter.DATA	字母	32位以内字母	只能字母
	    symbol.DATA	符号	5位以内符号	只能符号
	    character_string.DATA	字符串	32位以内数字、字母或符号	可数字、字母或符号组合
	    time.DATA	时间	24小时制时间格式（支持+年月日）	例如：15:01，或：2019年10月1日 15:01
	    date.DATA	日期	年月日格式（支持+24小时制时间）	例如：2019年10月1日，或：2019年10月1日 15:01
	    amount.DATA	金额	1个币种符号+10位以内纯数字，可带小数，结尾可带“元”	可带小数
	    phone_number.DATA	电话	17位以内，数字、符号	电话号码，例：+86-0766-66888866
	    car_number.DATA	车牌	8位以内，第一位与最后一位可为汉字，其余为字母或数字	车牌号码：粤A8Z888挂
	    name.DATA	姓名	10个以内纯汉字或20个以内纯字母或符号	中文名10个汉字内；纯英文名20个字母内；中文和字母混合按中文名算，10个字内
	    phrase.DATA	汉字	5个以内汉字	5个以内纯汉字，例如：配送中
     *
     * 微信发送消息数据结构
     * $data[NoticeEnum::TYPE_MINI_BACKEND_SEND] = [
        "uid" => 1, //用户的id
     *  "storeId" => 1, //店铺id
        "tplName" => ''//订阅模版枚举
        "params" => [a=>'b'], //跳转页面参数
        "data" => [ //消息模板数据
            "number01" => [
                "value" => "商品名称",
            ],
            "date01" => [
                "value" => "A8204427546131350100",
            ],
            "site01" => [
                "value" => "￥30",
            ],
            "keyword4" => [
                "value" => date('Y-m-d'),
            ]

        ]
    ];

     *
     * 短信发送消息数据结构
    $data[NoticeEnum::TYPE_TENCENT_SMS] = [
        [
            'storeId' => 198
            "templateId" => "178822", //模板id
            "phoneNumber" => "17558430002",
            "param" => [ //模板变量名
                "1580",
                "5"
            ]
        ]
    ];
     *
     * 微信公众号发送实例
    $data[NoticeEnum::TYPE_MP_SEND] = [
        'unionId' => 'o3lFcs8xoWfQUlhzTiP5uZI6A7Hc', //填写用户的unionId
        'tplName' => 模版KEY,
        'params' => [],//小程序或url地址参数（不用传地址）array
        'data' => [
            'first' => 'first',
            'keyword1' => '姓名',
            'keyword2' => '1213456',
            'keyword3' => '测试门店',
            'keyword4' => '门店地址',
            'keyword5' => 'test',
            'remark' => 'remark'
        ]
    ];
     *
     * 系统发送消息数据结构
    $data[NoticeEnum::TYPE_SYSTEM_SEND] = [
      NoticeEnum::TYPE_SYSTEM_SEND=>[
	    'storeId' => 198
	    "userId" => "1", //用户id
	    "content" => "内容",
	    "page" => "", //页面地址
        "isUpdate"=> bool ,//是否更新 根据page storeId userId更新未读消息内容
      ]
    ];
     *
     *
     * @param array $sendTypes
     * @param array $data
     * @param $sendTime   //如果需要多个时间段发送则填写时间戳数组例如:[15800000,1580000]
     * @param string $redisKey   //发送事件的redis key（如果定时发送消息，中途需要取消则需要传入此项）
     * @return mixed
     */
    public function send(array $sendTypes, array $data,  $sendTime, string  $redisKey='') :bool;


	/**
	 * 公众号客服消息
	 *
	 * @param string $openId
	 * @param int    $oemId
	 * @return void
	 */
    public function costumerSend(string $openId, int $oemId = 0);


    /**
     * 取消定时消息发送
     *
     * @param string $redisKey
     * @return bool
     */
    public function cancelSend(string $redisKey):bool ;
}