<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/5
 * Time: 13:15
 */
namespace Hdll\Services\Order\Enum;

class OrderEnum
{
    //订单状态
    const STATUS_CANCEL = 0; //已取消
    const STATUS_UNPAID = 10; //待支付
    const STATUS_PAID = 20; //已支付
    const STATUS_TAKE_ORDER = 21; //卖家已接单
    const STATUS_WAIT_DLV = 22; //待取货
    const STATUS_DELIVERY = 30; //已发货|配送中|已预约
    const STATUS_ARRIVED = 31;  //已送达
    const STATUS_DELIVERED = 40; //已收获|已核销
    const STATUS_REFUND = 50; //申请退款
    const STATUS_REFUNDED = 60; //已退款
    const STATUS_CLOSED = 70; //已关闭
    const STATUS_REFUNDING = 80; //退款中
    const STATUS_EVALUATION = 90; //已评价
    const STATUS_COLLECTION = 100; //团购进行中

    //支付后的所有状态数组
    const PAID_STATUS  = [
        self::STATUS_PAID,
        self::STATUS_DELIVERY,
        self::STATUS_ARRIVED,
        self::STATUS_REFUND,
        self::STATUS_REFUNDING,
        self::STATUS_DELIVERED,
        self::STATUS_EVALUATION
    ];

    //订单类别
    const CLASS_SERVICE = 1;//服务类
    const CLASS_PHYSICAL = 2;//实物类
    const CLASS_CATERING = 3;//餐饮类

    //订单类型
    const TYPE_GOODS = 0; //商品订单
    const TYPE_CUT_PRICE = 1; //砍价订单
    const TYPE_LIMIT = 2; //限时购订单
    const TYPE_COLLECTION = 3; //拼团订单
    const TYPE_CARD = 4; //储值卡订单
    const TYPE_TIMESCARD = 5; //次卡订单
    const TYPE_DEPOSIT = 6;//定金订单
    //订单类型数组
    const ORDER_TYPES = [
        self::TYPE_GOODS,
        self::TYPE_CUT_PRICE,
        self::TYPE_LIMIT,
        self::TYPE_COLLECTION,
        self::TYPE_CARD,
        self::TYPE_TIMESCARD,
        self::TYPE_DEPOSIT
    ];

    //订单改价
    const CHANGE_PRICE_FALSE = 1;//未改价
    const CHANGE_PRICE_TRUE = 2;//改价

    //对账状态
    const BALANCE_STATE_FALSE = 0; //未对账
    const BALANCE_STATE_TRUE = 1;//已对账
    const LOCK = 1; //对账异常锁定

    //退款状态
    const REFUND_NONE = 0;//无退款
    const REFUND_PART = 1;//部分退款
    const REFUND_SUCCESS = 2; //退款成功(全部退款)
    const REFUND_REJECTED = 3; //拒绝退款
    const REFUND_REVOKE = 4; //买家撤销退款

    const DLV_SEND = 1; //餐饮订单交货方式：配送
    const DLV_SELF_TAKE = 2; //餐饮订单交货方式：自提

    const SEND_TYPE_3RD = 1; //配送方式：第三方配送公司
    const SEND_TYPE_SELF = 2; //配送方式：商家自己配送


}