<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/8
 * Time: 10:43
 */

namespace Hdll\Services\Goods\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferGet($storeId, $id)
 * @method ResultInterface deferIncSales($storeId, $goodsId)
 * @method ResultInterface deferDecSales($storeId, $goodsId)
 * @method ResultInterface deferGetServiceByGoodsId($storeId, $goodsId, $type = 3)
 * @method ResultInterface deferGetReturnVisitByGoodsId($storeId, $goodsId, $type = 2)
 * @method ResultInterface deferListByIds($ids, $storeId)
 * @method ResultInterface deferAfterServiceTmp($storeId)
 * Interface GoodsInterface
 * @package Hdll\Services\Goods\Lib
 */
interface GoodsInterface
{

	/**
	 * 获取商品
	 * @param $storeId
	 * @return [
	 *                'gcId'   商品类ID
	 *                'asId'   服务ID
	 *                'stock'  库存
	 *                'name'   名称
	 *                'image'  图片
	 *                'price'  价格
	 *                'state'  状态
	 *                'body'   描述
	 *                'originalPrice'  原价
	 *                'sales'  销量
	 *                ]
	 * @param $id
	 * @return mixed
	 * @author Administrator
	 */
	public function get($storeId, $id);


	/**
	 * 增加商品销量
	 * 减少商品库存
	 * @param $storeId
	 * @param $goodsId
	 * @return mixed
	 * @author Administrator
	 */
	public function incSales($storeId, $goodsId);

	/**
	 * 减少商品销量
	 * 增加商品库存
	 * @param $storeId
	 * @param $goodsId
	 * @return mixed
	 * @author Administrator
	 */
	public function decSales($storeId, $goodsId);


	/**
	 * 获取商品服务
	 * @param $storeId
	 * @param $goodsId
	 * @param $type 1 付款后 2 服务前 3 服务后
	 * @return mixed
	 * @author Administrator
	 */
	public function getServiceByGoodsId($storeId, $goodsId, $type = 3);


	/**
	 * 获取用户回访
	 * @param $storeId
	 * @param $goodsId
	 * @param $type 1 之前 2 之后
	 * @return mixed
	 * @author Administrator
	 */
	public function getReturnVisitByGoodsId($storeId, $goodsId, $type = 2);

	/**
	 * 获取商品列表 ids
	 * @param $ids
	 * @param $storeId
	 * @param $order
	 * @return mixed
	 * @author Administrator
	 */
	public function listByIds(array $ids, $storeId, $order = ['id', 'DESC']);

	/**
	 * 添加后续服务模版
	 * @param $storeId
	 * @return mixed
	 * @author work
	 */
	public function afterServiceTmp($storeId);
}