<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/9/6
 * Time: 10:23
 */
namespace Hdll\Services\Notice\Extensions\Notice;

use Hdll\Services\Notice\Common\WxMiniNotice;
use Hdll\Services\Notice\Enum\NoticeEnum;

/**
 * Class MiniFrontendSender
 * @package Hdll\Services\Notice\Extensions\Notice
 */
class MiniFrontendSender implements SenderInterface
{

    private $sendType = NoticeEnum::TYPE_MINI_FRONTEND_SEND;

    private $data;

    private $user;

    private $page;

    private $sendData;

    private $template;

    /**
     *
     * $send = new MiniFrontendSender( ['id' => 1, 'storeId' => 198],
     * [
     *     'page' => 'pages/orderShow/orderShow',
     *     'param' => ['orderId' => 1, 'storeId' => 168]
     * ],
     * [
     *     1 => 'aaaaaaa',
     *     2 => 'msg',
     *     3 => '您好，您申请的退款不符合条件被拒绝',
     * ],
     * 'jcqYc-gHjkv-T8pDW8wjYFha0TKzCJTV3yNeGY3JW-0'
     * );
     * MiniFrontendSender constructor.
     *
     * @param array $user
     * @param array $page
     * @param array $sendData
     * @param string $template
     */
    public function __construct(array $user,array $page, array $sendData, string $template)
    {
        $this->user = $user;
        $this->page = $page;
        $this->sendData = $sendData;
        $this->template = $template;
    }

    /**
     * 格式化数据
     */
    public function format()
    {

        //$sendType
        $this->data[$this->sendType] = [
            "uid" => $this->user['id'], //用户的id
            "storeId" => $this->user['storeId'], //店铺的id
            "template_id" => $this->template,//消息模板id
            "page" => WxMiniNotice::generatePage(
                $this->page['page'],
                $this->page['param']
            ), //消息模板页面
        ];

        foreach ( $this->sendData as $key => $data ) {
            $key +=1;
            $this->data[$this->sendType]['data']["keyword{$key}"]['value'] = $data;
        }

    }


    /**
     * 获取发送数据
     *
     * @return mixed
     */
    public function getData ()
    {
        return $this->data;
    }

    /**
     * 获取发送类型
     *
     * @return array
     */
    public function getSendType()
    {
        return [$this->sendType];
    }

}