<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/27
 * Time: 16:28
 */

namespace Hdll\Services\Seller\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSave($referId, $unionId, $openId, $nickName, $headImgUrl)
 * @method ResultInterface deferGet($id,$fields=['*'])
 * @method ResultInterface deferGetByUnionId($unionId,$fields=['*'])
 * @method ResultInterface deferGetByStoreId($storeId,$fields=['*'])
 * @method ResultInterface deferUpdate($id,$data)
 * Interface SellerInterface
 * @package App\Lib
 */
interface SellerInterface
{

	/**
	 * @param        $referId
	 * @param        $unionId
	 * @param        $openId
	 * @param        $nickName
	 * @param        $headImgUrl
	 * @param string $realName
	 * @param string $phoneNumber
	 * @return mixed
	 * @author Administrator
	 */
	public function save($referId, $unionId, $openId, $nickName, $headImgUrl);

	/**
	 * @param       $id
	 * @param array $fields
	 * @return mixed
	 * @author Administrator
	 */
	public function get($id,$fields=['*']);

	/**
	 * @param       $unionId
	 * @param array $fields
	 * @return mixed
	 * @author Administrator
	 */
	public function getByUnionId($unionId,$fields=['*']);

	/**
	 * @param $condition
	 * @param $data
	 * $data['referId']=>'来源ID'
	 * $data['unionId']=>'unionId'
	 * $data['openId']=>'openId'
	 * $data['nickName']=>'昵称'
	 * $data['headImgUrl']=>'头像URL'
	 * $data['realName']=>'真实姓名'
	 * $data['phoneNumber']=>'手机号'
	 * @return mixed
	 * @author Administrator
	 */
	public function update($condition,$data);

	/**
	 * @param       $storeId
	 * @param array $fields
	 * @return mixed
	 * @author Administrator
	 */
	public function getByStoreId($storeId, $fields = ['*']);

}