<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\FrontMoney\Lib;

use Hdll\Services\FrontMoney\Enum\FrontOrderEnum;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferBackNum(string $token, int $consigneeId, int $frontId, int $selectedNum, int $orderType, int $goodsId, string $reservationTime = '')
 * @method ResultInterface deferGetFrontGoods(int $storeId, int $frontId)
 * @method ResultInterface deferGetFrontInfo(int $storeId, int $goodsId)
 * @method ResultInterface deferPayStatus(string $storeId,int $frontId, int $status, int $orderId)
 * @method  ResultInterface deferGetFrontCounts(int $storeId)
 * @method  ResultInterface deferGetNotEndedActivityList($storeId)
 * @method ResultInterface deferGetNewOrderNum(int $storeId,int $lastTime)
 */
interface FrontMoneyInterface
{
    /**
     *
     * 补回  未支付 定金活动  库存
     * @param string $token
     * @param int $consignee_id
     * @param int $front_id
     * @param int $selected_num
     * @param int $order_type
     * @param int $goods_id
     * @param string $reservation_time
     * @return mixed
     */
    public function backNum(string $token, int $consigneeId, int $frontId, int $selectedNum, int $orderType, int $goodsId, string $reservationTime = '');
      

    /**
     *  获取定金商品的 商品信息
     * @param int $front_id
     * @return {
     * "name"              名称
     * "image"             图片
     * "price"             价格
     * "activityName"      活动名称
     * }
     */
    public function getFrontGoods(int $storeId, int $frontId);

    /**
     * 通过商品id  获取是否 有定金活动
     * @param int $storeId
     * @param int $goodsId
     * @return bool
     *
     */
    public function getFrontInfo(int $storeId, int $goodsId);


    /**
     * 支付 状态 回馈接口
     * @param string $store_id
     * @param int $front_id
     * @param int $status // 2.FrontOrderEnum::STATUS_HAVE_PAY 成功支付  3：FrontOrderEnum::STATUS_PAY_EXCEPTION 未支付 （已经过期或者支付异常）4 FrontOrderEnum::STATUS_PAY_REFUND  退款
     * @param int $orderId
     * @return bool|mixed
     * @throws ConException
     */
    public function payStatus(string $storeId,int $frontId, int $status, int $orderId);

    /**
     * 获取定金活动总个数 和正在进行的个数
     *
     * @return mixed
     */
    public function getFrontCounts(int $storeId);

     /**
     * 获取店铺尚未结束的活动列表
     *
     * @return mixed
     */
    public function getNotEndedActivityList($storeId);


    /**
     *获取自上次时间以来产生的新订单数
     *
     * @param [int] $storeId
     * @param [int] $lastTime
     * @return int
     */
    public function getNewOrderNum(int $storeId,int $lastTime);
}