<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Order\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method ResultInterface deferCreateOrder(int $buyerId,int $storeId,int $consigneeId,int $itemId,int $selectedNum,int $orderType,int $activityPrice,string $goodsName,string $goodsImage,string $activityName,int $goodsId,int $goodsPrice,string $message='',int $skuId=0,int $subStoreId=0,int $couponId=0);
 * @method ResultInterface deferGetOrderDetailBySubId(int $storeId,int $subOrderId,$ifSelf=true,bool $ifExtend=false)
 * @method ResultInterface deferGetOrderDetailByPid(int $storeId,int $pId,bool $ifExtend=false)
 * @method ResultInterface deferGetSubOrderBySubId(int $storeId, int $subOrderId)
 * 
 * @method ResultInterface deferUpdateInfoById(int $storeId,int $orderId, array  $updateInfo)
 * @method ResultInterface deferGetSimpleList($storeId, $condition, $fields = ['*'])
 * @method ResultInterface deferUpdateInfoByIds(int $storeId,array $orderIds, array  $updateInfo)
 * @method ResultInterface deferCollectionClose(int $storeId, int $orderId)
 * @method ResultInterface deferGetOtherInfo(int $storeId, string $orderSn, array $consigneeFields = [], array $itemFields = [])
 * @method ResultInterface deferGetList(int $storeId,array $ids)
 * @method ResultInterface deferUnconfirmedCount(int $storeId)
 * @method ResultInterface deferGetOrder($orderSn)
 */
interface OrderInterface
{
    /**
     * 创建订单
     *
     * @param integer $buyerId
     * @param integer $storeId
     * @param integer $consigneeId
     * @param integer $itemId
     * @param integer $selectedNum
     * @param integer $orderType
     * @param integer $activityPrice
     * @param string $goodsName
     * @param string $goodsImage
     * @param string $activityName
     * @param integer $goodsId
     * @param integer $goodsPrice
     * @param string $message
     * @param integer $skuId
     * @param integer $subStoreId
     * @param integer $couponId
     * @return mixed
     */
    public function createOrder(
        int     $buyerId,
        int     $storeId,
        int     $consigneeId,
        int     $itemId,
        int     $selectedNum,
        int     $orderType,
        int     $activityPrice,
        string  $goodsName,
        string  $goodsImage,
        string  $activityName,
        int     $goodsId,
        int     $goodsPrice,
        string  $message = '',
        int     $skuId=0,
        int $subStoreId=0,
        int $couponId=0
    );
   /**
    * 根据子订单ID只查询子订单信息
    *
    * @param integer $storeId 店铺ID
    * @param integer $subOrderId 子订单ID
    * @return array
    */
    public function getSubOrderBySubId(int $storeId, int $subOrderId);
    /**
    * 根据子订单ID查询订单详情
    *
    * @param integer $storeId 店铺ID
    * @param integer $subOrderId 子订单ID
    * @param boolean $ifSelf  子订单是否只有自己
    * @param boolean $ifExtend 是否涵带附加信息（如门店信息、上级信息等）
    * @return array
    */
    public function getOrderDetailBySubId(int $storeId,int $subOrderId,$ifSelf=true,bool $ifExtend=false);
    /**
    * 根据主订单ID查询订单详情
    *
    * @param integer $storeId 店铺ID
    * @param integer $pId 主订单ID
    * @param boolean $ifExtend 是否涵带附加信息（如门店信息、上级信息等）
    * @return array
    */
    public function getOrderDetailByPid(int $storeId,int $pId,bool $ifExtend=false);
    
    public function getOrderInfoBySn(int $storeId, string $orderSn, array $consigneeFields = [], array $itemFields = []);

    public function updateInfoById(int $storeId,int $orderId, array  $updateInfo);

    public function closeOrder(int $storeId,int $orderId);

    /**
     * 获取订单数据
     * 字段值
     * `id`,
    `orderSn`,
    `paySn`,
    `orderType`  '订单类型：0普通商品，1活动',
    `storeId`, 店铺id
    `buyerId` ,买家id
    `itemId`  '0',
    `consigneeId` '付款人（收货人）ID，当线下订单时为空',
    `goodsAmount` ,
    `orderAmount`  '订单应付款',
    `actualAmount`  '订单实付款',
    `refundAmount`  '退款金额',
    `state`  '订单状态：0(已取消)10(默认):未付款;20:已付款;30:已发货/已预约;40:已收货/已核销;50-申请退款;60退款成功,70 已关闭,80,退款中,90,已评价',
    `refundState`  '0' COMMENT '退款状态:0是无退款,1是部分退款,2是全部退款',
    `refundMsg`'退款原因',
    `lockState`  '锁定状态:0是正常,大于0是锁定',
    `lockMsg`  '订单锁定原因',
    `balanceState`  '对账状态：0-未对账，1-已对账',
    `balanceTime` '对账时间',
    `message` ,
    `reservationTime`  ,
    `createTime`  创建时间,
    `updateTime`  更新时间,
    `deleteTime`  删除时间,
    `sellerId`   '卖家id',
    `deliveredTime`  '核销时间',
     *
     *
     * @param $storeId
     * @param $condition
     * @param array $fields
     * @return mixed
     */
    public function getSimpleList($storeId, $condition, $fields = ['*']);


    /**
     * 退款成功
     *
     * @param int $storeId
     * @param array $orderInfo
     * @return mixed
     */
    public function refundSuccess(int $storeId, array $orderInfo);

    /**
     * 拼团关闭订单，含退款
     *
     * @param int $storeId
     * @param int $orderId
     * @return mixed
     */
    public function collectionClose(int $storeId, int $orderId);

    /**
     * 批量更新
     *
     * @param int $storeId
     * @param array $orderIds
     * @param array $updateInfo
     * @return mixed
     */
    public function updateInfoByIds(int $storeId,array $orderIds, array  $updateInfo);

    /**
     * 获取订单联系人信息，item信息用
     *
     * @param int $storeId
     * @param string $orderSn
     * @param array $consigneeFields
     * @param array $itemFields
     * @return mixed
     */
    public function getOtherInfo(int $storeId, string $orderSn, array $consigneeFields = [], array $itemFields = []);


    /**
     * 批量获取订单信息
     *   [5]=>
     * array(28) {
        ["id"]=>
        string(1) "1"
        ["orderSn"]=>
        string(20) "198bSA93091872375217"
        ["paySn"]=>
        string(28) "4200000198201809300361147593"
        ["orderType"]=>
        string(1) "0"
        ["storeId"]=>
        string(3) "198"
        ["buyerId"]=>
        string(1) "1"
        ["itemId"]=>
        string(1) "1"
        ["consigneeId"]=>
        string(1) "1"
        ["goodsAmount"]=>
        string(1) "1"
        ["orderAmount"]=>
        string(1) "1"
        ["actualAmount"]=>
        string(1) "1"
        ["refundAmount"]=>
        string(1) "1"
        ["state"]=>
        string(2) "60"
        ["refundState"]=>
        string(1) "2"
        ["refundMsg"]=>
        string(30) "身体不适，暂时不做了"
        ["lockState"]=>
        string(1) "0"
        ["lockMsg"]=>
        string(0) ""
        ["balanceState"]=>
        string(1) "0"
        ["balanceTime"]=>
        string(1) "0"
        ["message"]=>
        string(0) ""
        ["reservationTime"]=>
        string(1) "0"
        ["createTime"]=>
        string(10) "1538291872"
        ["updateTime"]=>
        string(10) "1538291953"
        ["deleteTime"]=>
        string(1) "0"
        ["sellerId"]=>
        string(1) "6"
        ["deliveredTime"]=>
        string(1) "0"
        ["commission"]=>
        string(1) "0"
        ["items"]=>
        array(1) {
            [0]=>
            array(2) {
            ["name"]=>
            string(7) "商品1"
            ["image"]=>
            string(72) "store-198/goods/tmp_7d07ba3c8e10c3cd65de8d98d00cbd5aace9e736ddde0c59.jpg"
            }
         }
        }
    }
     *
     * @param int $storeId
     * @param array $ids
     * @return mixed
     */
    public function getList(int $storeId,array $ids);

    /**
     * 统计核销
     *
     * array(2) {
    ["money"]=>
    string(1) "8"
    ["orders"]=>
    string(1) "6"
    }
     * @param int $storeId
     * @return mixed
     */
    public function unconfirmedCount(int $storeId);

    public function getOrder($orderSn);

    public function getTotal(int $storeId);

}