<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Bargain\Lib;

use Hdll\Services\Bargain\Enum\BargainEnum;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferGetgoodsinfo(int $limit_id)
 * @method  ResultInterface deferGetBargainInfo(int $limit_id)
 * @method  ResultInterface deferGetBargainCounts()
 */
interface BargainInterface
{

    /**
     *  获取砍价商品的 商品信息
     * @param int $bargain_id
     * @return {
     * "name"              名称
     * "image"             图片
     * "price"             价格
     * "activityName"      活动名称
     * }
     */
    public function getGoodsInfo(
        int $stordId, int $bargain_id
    );


    /**
     * 通过商品id  获取是否 有砍价活动
     * @param int $storeId
     * @param int $goodsId
     * @return bool
     *
     */
    public function getBargainInfo(
        int $storeId, int $goodsId
    );


    /**
     * 支付 状态 回馈接口
     * @param string $storeId //
     * @param int $bargainbranchId // 砍价活动id
     * @param int $status // BargainEnum::HAVE_PAY 成功支付  BargainEnum::PAY_EXCEPTION：未支付 （已经过期或者支付异常）
     * @return mixed
     */
    public function payStatus(
        string $storeId,
        int $bargainbranchId,
        int $status ,  //
        int $orderId);

  /**
     * 获取砍价活动总个数 和正在进行的个数
     *
     * @return mixed
     */
    public function getBargainCounts();
        
}




 