<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/25
 * Time: 14:00
 */
namespace Hdll\Services\SellerDistribution\Lib;
use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSaveBill($orderId, $sellerId, $money)
 * @method ResultInterface deferGetCommission($sellerId)
 * @method ResultInterface deferAddBalance($sellerId, $money, $orderSn='')
 * @method ResultInterface deferReduceBalance($sellerId, $money, $orderSn='')
 * @method ResultInterface deferListByOrderId($storeId, $orderId,$sellerId)
 * @method ResultInterface deferAddTotal($sellerId, $money, $orderSn='')
 * @method ResultInterface deferRefundAddBalance($sellerId, $money, $orderSn='')
 * @method ResultInterface deferCountVip($storeId, $sellerId)
 * Interface SellerDistributionInterface
 * @package App\Lib
 */
interface SellerDistributionInterface{


	/**
	 * 保存账单
	 * @param        $orderId
	 * @param        $sellerId
	 * @param        $money
	 * @param        $level
	 * @param string $memo
	 * @return mixed
	 * @author Administrator
	 */
	public function saveBill($orderId, $sellerId, $money);


	/**
	 * 获取佣金信息
	 * @param $sellerId
	 * @return mixed
	 * totalCommission  累计佣金
	 * balanceCommission    可提现佣金
	 * @author Administrator
	 */
	public function getCommission($sellerId);

	/**
	 * 增加佣金
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addBalance($sellerId, $money, $orderSn='');

	/**
	 * 减少佣金
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceBalance($sellerId, $money, $orderSn='');


	/**
	 * 获取分销记录
	 * @param $storeId
	 * @param $orderId
	 * @param $sellerId
	 * @return mixed
	 * @author Administrator
	 */
	public function listByOrderId($storeId, $orderId,$sellerId);

	/**
	 * 更细对账表
	 * @param $storeId
	 * @param $id
	 * @param $balanceState 0 未对帐 1 已对账
	 * @return mixed
	 * @author Administrator
	 */
	public function updateBill($storeId,$id,$balanceState);

	/**
	 * 增加累计提现
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addTotal($sellerId, $money, $orderSn='');


	/**
	 * 退款增加佣金(不增加累计金额)
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function refundAddBalance($sellerId, $money, $orderSn='');


	/**
	 * 统计VIP数量
	 * @param $storeId
	 * @param $sellerId
	 * @return mixed
	 * @author Administrator
	 */
	public function countVip($storeId, $sellerId);
}