<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/5
 * Time: 13:15
 */
namespace Hdll\Services\Order\Enum;

class OrderEnum
{

  
    //订单状态
    const STATUS_UNPAID = 10; //待支付
    const STATUS_PAID = 20; //已支付
    const STATUS_DELIVERY = 30; //已发货/已预约
    const STATUS_DELIVERED = 40; //已收获/已核销
    const STATUS_REFUND = 50; //申请退款
    const STATUS_REFUNDED = 60; //已退款
    const STATUS_CANCEL = 0; //已取消
    const STATUS_CLOSED = 70; //已关闭
    const STATUS_REFUNDING = 80; //退款中
    const STATUS_EVALUATION = 90; //已评价
    const STATUS_COLLECTION = 100; //团购进行中

    //订单类型
    const TYPE_GOODS = 0; //商品订单
    const TYPE_CUT_PRICE = 1; //砍价订单
    const TYPE_LIMIT = 2; //限时购订单
    const TYPE_COLLECTION = 3; //拼团
    const TYPE_CARD = 4; //储值卡购买订单
    const TYPE_TIMESCARD = 5; //次卡


    
    const CHANGE_PRICE_FALSE = 1;
    const CHANGE_PRICE_TRUE = 2;
    

    //对账锁定
    const LOCK = 1; //订单锁定

    const ORDER_TYPES = [
        self::TYPE_GOODS,
        self::TYPE_CUT_PRICE,
        self::TYPE_LIMIT,
        self::TYPE_COLLECTION,
        self::TYPE_CARD,
        self::TYPE_TIMESCARD
    ];

    //可以直接预约的订单类型
    const CAN_RESERVE = [
        self::TYPE_GOODS,
        self::TYPE_CUT_PRICE,
        self::TYPE_LIMIT,
    ];

    const PAY_STATUS  = [ //支付状态
        self::STATUS_PAID,
        self::STATUS_DELIVERY,
        self::STATUS_COLLECTION
    ];

    const PAID_STATUS  = [ //支付后的所有状态数组
        self::STATUS_PAID,
        self::STATUS_DELIVERY,
        self::STATUS_DELIVERED,
        self::STATUS_EVALUATION
    ];

    //对账状态
     const BALANCE_STATE_FALSE = 0; //未对账
     const BALANCE_STATE_TRUE = 1;//已对账


    const REFUND_SUCCESS = 2; //退款成功
    const REFUND_REJECTED = 3; //拒绝退款




}