<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Craftsman\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of craftsman service
 *
 * @method ResultInterface deferGetCraftsmenList(int $storeId, int $subStoreId = 0, int $itemId = 0)
 * @method ResultInterface deferGetCraftsmenByUnionId(int $unionId)
 * @method ResultInterface deferGetCraftsmenById(int $storeId, int $cmanId)
 */
interface CraftsmanInterface
{
    // 店员服务的字段说明：
    // name       店员名字
    // sex        性别
    // mobile     店员手机
    // inReview   审核状态，1审核中，2审核通过
    // headimg    店员头像
    // items      服务项目id列表，逗号隔开
    // subStores  子店铺id列表，逗号隔开
    // motto      个人签名
    // adept      个人擅长说明
    // wechat     店员微信号

    /**
     * 获取店员列表
     *
     * @param integer $storeId
     * @param integer $subStoreId  子店铺id
     * @param integer $itemId      服务项目（商品）id

     * @return array
     */
    public function getCraftsmenList(int $storeId, int $subStoreId = 0, int $itemId = 0);

    /**
     * 根据unionId获取店员信息
     *
     * @param integer $unionId
     * @return array
     */
    public function getCraftsmenByUnionId(int $unionId);

    
    /**
     * 根据店铺Id和店员Id获取店员信息
     *
     * @param integer $storeId
     * @param integer $cmanId
     * @return array
     */
    public function getCraftsmenById(int $storeId, int $cmanId);

}