<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/2
 * Time: 9:49
 */
namespace Hdll\Services\Buyer\Lib;

/**
 * Interface CommissionInterface
 * @package Hdll\Services\Buyer\Lib
 */
interface CommissionInterface
{
    /**
     * 扣除可提现金额（仅限于对账服务使用，切记！！！）
     *
     * @param $storeId
     * @param $buyerId
     * @param $money
     * @return bool
     */
    public function reduceBalanceCommissionCompare($storeId, $buyerId, $money);

    /**
     * 增加可提现金额（仅限于对账服务使用，切记！！！）
     * 
     * @param $storeId
     * @param $buyerId
     * @param $money
     * @return bool
     */
    public function addBalanceCommissionCompare($storeId, $buyerId, $money);

    /**
     * 增加累计现金额
     *
     * @param $storeId
     * @param $buyerId
     * @param $money
     * @return bool
     */
    public function addTotalCommission($storeId, $buyerId, $money);

}