<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/2
 * Time: 9:49
 */
namespace Hdll\Services\Buyer\Lib;

/**
 * Interface CommissionInterface
 * @package Hdll\Services\Buyer\Lib
 */
interface CommissionInterface
{
    /**
     * 扣除可提现金额
     *
     * @param $storeId
     * @param $buyerId
     * @param $money
     * @return mixed|bool
     */
    public function reduceBalanceCommission($storeId, $buyerId, $money);

    /**
     * 增加可提现金额
     * 
     * @param $storeId
     * @param $buyerId
     * @param $money
     * @return bool
     */
    public function addBalanceCommission($storeId, $buyerId, $money);

}