<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\TimesCard\Lib;

use Hdll\Services\Recharge\Enum\BuyCardPayStatus;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferPayStatus(int $storeId,int $bargainbranchId,int $status,int $orderId)
 * @method  ResultInterface deferSpendTimesCard(int $storeId, int $buyerId, int $usercardId, array $subOrders)
 * @method  ResultInterface deferReturnCardTimes( int $storeId,int $buyerId,int $itemOrderId,int $goodsId,string $itemTitle,int    $times)
 * @method  ResultInterface defergetTimesCardUserCardInfo(int $storeId, int $goodsId)
 * @method  ResultInterface deferStatisNum( int $storeId)
 */
interface TimesCardInterface
{


    /**
     * 微信支付 状态 回馈接口
     * @param string $storeId //
     * @param int $itemId // 项目ID $localorderId
     * @param int $status // BuyCardPayStatus::HAVE_PAY 成功支付  BuyCardPayStatus::PAY_EXCEPTION：未支付 （已经过期或者支付异常）
     * @return mixed
     */
    public function payStatus(
        int $storeId,
        int $itemId,
        int $status ,  //
        int $orderId);

    /**
     * 花费卡次数
     *
     * @param integer $storeId
     * @param integer $buyerId
     * @param integer $usercardId
     * @param array $subOrders
     * @return bool
     */
    public function spendTimesCard(int $storeId, int $buyerId, int $usercardId, array $subOrders);

    /**
     * 退回次卡数量
     * @param int $storeId
     * @param int $buyerId
     * @param int $itemOrderId
     * @param string $itemTitle
     * @param int $payMoney
     * @return mixed
     */
    public function ReturnCardTimes(
        int $storeId,
        int $buyerId,
        int $itemOrderId,
        int $goodsId,
        string $itemTitle,
        int $times
    );


    /**
     * 通过商品id  获取是否 有正在服务的次卡用户
     * @param int $storeId
     * @param int $goodsId
     * @return bool
     *
     */
    public function getTimesCardUserCardInfo(
        int $storeId, int $goodsId
    );

    /**
     * 统计次卡上架数/总数
     * @param int $storeId
     * @return mixed
     * 响应数据：
     * [
     *  'num' => 上架数,
     *  'total' => 总数
     * ]
     */
    public function statisNum(int $storeId);
}




 