<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Insurance\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of insurance service
 *
 * @method ResultInterface deferGetOrderInfo(int $storeId, int $orderId)
 * @method ResultInterface deferGetOrderBySn(int $storeId, $orderSn)
 * @method ResultInterface deferPaySuccess(int $storeId, $orderSn)
 */
interface InsuranceInterface
{
    /**
     * 获取指定订单数据
     *
     * @param integer $storeId
     * @param integer $orderId
     * @return array
     */
    public function getOrderInfo(int $storeId, int $orderId);

    /**
     * 获取指定订单数据
     *
     * @param integer $storeId
     * @param integer $orderSn
     * @return array
     */
    public function getOrderBySn(int $storeId, $orderSn);

    /**
     * 支付成功回调
     *
     * @param integer $storeId
     * @param string  $orderSn
     * @Number(name="storeId")
     * @return void
     */
    public function paySuccess(int $storeId, $orderSn);

}