<?php

namespace Hdll\Services\Logistics\Lib;

use App\Exception\BaseException;
use App\Exception\RpcException;
use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferOnPath(array $param)
 * @method ResultInterface deferHandleFreight($storeId, array $receiver, array $goods)
 * Class LotteryInterface
 * @package Hdll\Services\Logistics\Lib
 */
interface LogisticsInterface
{

	public function onPath(array $param);


	public function imOnPath(array $param);

	/**
	 * 获取运费
	 * @param       $storeId
	 * @param array $receiver
	 * @param array $goods
	 * @return mixed
	 */
	public function handleFreight($storeId, array $receiver, array $goods);

	/**
	 * 获取收货人地址
	 * @param $id
	 * @param $storeId
	 * @return mixed
	 */
	public function getReceiver($id, $storeId);

	/**
	 * 获取即时配送收货人地址
	 * @param $id
	 * @param $storeId
	 * @return array
	 */
	public function getImReceiver($id, $storeId);

	/**
	 * 预下单
	 * @param       $storeId
	 * @param       $buyerId
	 * @param array $receiver         收货人信息
	 * @param       $orderSn          订单号
	 * @param       $items            商品信息
	 *                                [
	 *                                ['name'=>'商品名称','image'=>'shang_pin_tu_pian'],
	 *                                ['name'=>'商品名称','image'=>'shang_pin_tu_pian'],
	 *                                ]
	 * @param       $price            商品总价
	 * @param       $poiSeq           流水号
	 * @param       $deliveryCode     配送服务代码 不同配送公司自定义, 顺丰和达达不填
	 * @return mixed
	 * @throws RpcException
	 */
	public function preOrder($storeId, $buyerId, array $receiver, $orderSn, $items, $price, $poiSeq, $deliveryCode = null);


	/**
	 * 下单
	 * @param       $storeId
	 * @param       $buyerId
	 * @param array $receiver         收货人信息
	 * @param       $orderSn          订单号
	 * @param null  $deliveryToken    预下单接口返回的参数，配送公司可保证在一段时间内运费不变
	 * @param       $deliveryCode     配送服务代码 不同配送公司自定义, 顺丰和达达不填
	 * @return mixed
	 * @throws RpcException
	 */
	public function order($storeId, $buyerId, array $receiver, $orderSn, $deliveryToken = null, $deliveryCode = null);
}