<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store-template service
 *
 * @method ResultInterface deferGetTemplateList(int $onshelf = 1)
 * @method ResultInterface deferGetTemplate(int $tplId)
 * @method ResultInterface deferUpdateStore(int $storeId, array $data)
 * @method ResultInterface deferDeleteStore(int $storeId)
 */
interface TemplateInterface
{
    /**
     * 获取所有可用的个性模板列表
     * onshelf=1表示查询已上架的模板
     * onshelf=2表示查询已下架的模板
     * @param int $onshelf  
     * @return array 空数组表示没有查询到记录
     */
    public function getTemplateList(int $onshelf = 1);

    /**
     * 根据模板ID获取单个模板信息
     *
     * @param integer $tplId
     * @return array 空数组表示没有查询到记录
     */
    public function getTemplate(int $tplId);

    
}