<?php

namespace hdll\services\generate;

use Swoft\Bean\Annotation\Bean;
use Swoft\Bean\Annotation\Inject;
use Swoft\Devtool\FileGenerator;
use Swoft\Devtool\Model\Data\SchemaData;

/**
 * Class GenData
 * @package hdll\services\generate
 */
class GenData
{

    /**
     * @Inject()
     * @var SchemaData
     */
    private $data;

    public function generate($param)
    {
        list($db, $inc, $exc, $path, $driver, $tablePrefix, $fieldPrefix, $tplFile, $tplDir) = $params;
        $tableSchemas = $this->data->getSchemaTableData($driver, $db, $inc, $exc, $tablePrefix);
        foreach ($tableSchemas as $tableSchema) {
            $this->generateClass($driver, $db, $tableSchema, $fieldPrefix, $path, $tplFile, $tplDir);
        }
    }

    public function generateData($driver, $db, $tableSchema, $fieldPrefix, $path, $tplFile, $tplDir)
    {
        $mappingClass = $tableSchema['mapping'];
        $config       = [
            'tplFilename' => $tplFile,
            'tplDir'      => $tplDir,
            'className'   => $mappingClass,
        ];

        $file = alias($path);
        $file .= sprintf('/%s.php', $mappingClass);

        $columnSchemas = $this->data->getSchemaColumnsData($driver,$db,$tableSchema['name'],$fieldPrefix);
        $data = [
            'tableName'  => $tableSchema['name'],
            'namespace'  => 'App\\Models\\Data',
        ];
        $gen  = new FileGenerator($config);
        $gen->renderas($file, $data);

    }

    public function generateSave()
    {

    }
}
