<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Common\Pool\Config;

use Swoft\Bean\Annotation\Bean;
use Swoft\Bean\Annotation\Value;
use Swoft\Pool\PoolProperties;

/**
 * the config of service user
 *
 * @Bean()
 */
class PayPoolConfig extends PoolProperties
{

	public function __construct()
	{
		// 区别本地和线上的RPC服务地址
		$this->uri = explode(',', env('RPC_PAY_URI', 'pay:8099'));
	}
    /**
     * the name of pool
     *
     */
    protected $name = 'pay';

    /**
     * Minimum active number of connections
     *
     */
    protected $minActive = 5;

    /**
     * the maximum number of active connections
     *
     */
    protected $maxActive = 300;

    /**
     * the maximum number of wait connections
     *
     */
    protected $maxWait = 400;

    /**
     * Maximum waiting time
     *
     */
    protected $maxWaitTime = 3;

    /**
     * Maximum idle time
     *
     */
    protected $maxIdleTime = 60;

    /**
     * the time of connect timeout
     *
     */
    protected $timeout = 200;

    /**
     * the addresses of connection
     *
     * <pre>
     * [
     *  '127.0.0.1:88',
     *  '127.0.0.1:88'
     * ]
     * </pre>
     *
     */
    protected $uri = [
        "192.168.3.100:8102",
    ];

    /**
     * whether to user provider(consul/etcd/zookeeper)
     *
     */
    protected $useProvider = false;

    /**
     * the default balancer is random balancer
     *
     */
    protected $balancer = '';

    /**
     * the default provider is consul provider
     *
     */
    protected $provider = '';
}
