<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/5
 * Time: 15:47
 */
namespace Hdll\Services\Buyer\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method  ResultInterface deferGetUser(string $token)
 * @method  ResultInterface deferUpdateProfile(string $token, array $data)
 * @method  ResultInterface deferSelectUser(int $storeId, array $buyerIds, array $fields= ['*'])
 * Interface BuyerInterface
 * @package App\Lib
 */
interface BuyerInterface
{
    /**
     * 获取用户信息
     *
     * @param int $storeId
     * @param int $buyerId
     * @return mixed
        array(8) {
            ["id"]=> int(1) //买家id
            ["unionId"]=>string(28) "oyDnT5OYVCQUC9X9ErkDHBNrad90"
            ["storeId"]=>int(0)//店铺id
            ["referId"]=>int(0)//推荐人ID
            ["state"]=>int(0)//买家状态
            ["nickName"]=>string(0) ""//买家昵称
            ["openId"]=>string(0) ""//买家openId
            ["profile"]=>
                array(4) {
                ["realName"]=>string(12) "真实姓名"
                ["gender"]=>int(1)//性别
                ["phoneNumber"]=>string(11) "18812345678"//手机号
                ["birthday"]=>int(0) //生日
            }
            ["commission"]=>
                array(3) {
                ["totalCommission"]=>int(10)//总共提现
                ["balanceCommission"]=>int(10)//可提现金额
                ["expectCommission"]=>int(20)//冻结提现金额
            }
        }
     *
     */
    public function getUser(int $storeId, int $buyerId);

    /**
     * 更新用户信息
     * $updateInfo = [
            "realName" => "真实姓名",
            "gender" => "性别",
            "phoneNumber" => "手机号",
            "birthday"  => "生日"
        ];
     * @param int $storeId
     * @param array $data
     * @return mixed
     */
    public function updateProfile(int $storeId, array $data);

    /**
     * 是否已经注册用户
     * @param $storeId
     * @param $unionid
     * @return mixed
     *
     * 返回值:
     * array(3) {
        ["id"]=> int(1)//买家id
        ["storeId"]=> int(1) //店铺id
        ["referId"]=> int(0) //推荐人id
        }
     */
    public function hasUser($storeId,$unionid);

    public function selectUser(int $storeId, array $buyerIds, array $fields= ['*']);
}