<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/27
 * Time: 16:28
 */

namespace Hdll\Services\FlowCount\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferAdd(int $storeId, array $data)
 * @method ResultInterface deferBrowse(int $storeId, array $itemIds)
 * @method ResultInterface deferShare(int $storeId, array $itemIds)
 * Interface VisitorInterface
 * @package App\Lib
 */
interface VisitorInterface
{

    /**
     * 添加访客
     * @param int $storeId
     * @param array $data
     * int $data['visitorId']=>访客id
     * int $data['date']=>访问时间
     * int $data['appType']=>访问的app类型   默认传值：1前台小程序，2后台小程序
     * string $data['nickName']=>'访客昵称'
     * string $data['headImgUrl']=>'访客头像URL'
     * @return mixed
     */
	public function add(int $storeId, array $data);

    /**
     * 访问量
     * @param int $storeId      店铺id
     * @param int $type         类型：0普通商品 1砍价 2限时购 3拼团
     * @param array $itemIds    商品或活动（活动指：砍价、限时购 、拼团）的id列表
     * 说明：$itemIds 格式[1,2,3]
     */
    public function browse(int $storeId, int $type, array $itemIds);

    /**
     * 转发量
     * @param int $storeId      店铺id
     * @param int $type         类型：0普通商品 1砍价 2限时购 3拼团
     * @param array $itemIds    商品或活动（活动指：砍价、限时购 、拼团）的id列表
     * 说明：$itemIds 格式[1,2,3]
     * @return mixed
     */
    public function share(int $storeId, int $type, array $iteamIds);

}