<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/17
 * Time: 14:19
 */

namespace App\Exception;

class SellerDistributionError
{

	const E001 = [001, '参数非法',400];
	const E002 = [002, '无效的Token',403];
	const E003 = [003, '无权限操作',403];
	const E004 = [004, '数据不存在',404];

	const E101 = [101, '微信支付错误', 500];
	const E102 = [102, '订单不存在或状态异常', 404];
	const E103 = [103, '升级VIP失败,没有找到对应的店铺', 404];

	public function getError($code)
	{
		$reflect = new \ReflectionClass(self::class);
		$arr = $reflect->getConstant('E' . substr($code, -3));
		if (!is_array($arr)) {
			return false;
		}
		return [
			'code' => $arr[0],
			'msg' => $arr[1],
			'errorCode' => $arr[2],
		];
	}
}