<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Schedule\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of Schedule service
 *
 * @method ResultInterface deferGetScheduleList(int $storeId, int $month=null)
 * @method ResultInterface deferGetScheduleByDateId(int $storeId, int $dateId)
 * @method ResultInterface deferUpdateSchedule(int $storeId, int $dateId, array $data)
 * @method ResultInterface deferAddSchedule(int $storeId, int $dateId, array $data)
 */
interface ScheduleInterface
{
    /**
     * 获取店铺所有日程列表
     *
     * @param integer $storeId
     * @param integer $month 可选参数 指定要查哪个月份的日程列表，格式如：201810
     * @return array 空数组表示没有查询到记录
     */
    public function getScheduleList(int $storeId, int $month = null);

    /**
     * 获取某天的日程信息
     *
     * @param integer $storeId
     * @param integer $dateId  要查询的日期id，格式要求如：20180803 
     * @return array 空数组表示没有查询到记录
     */
    public function getScheduleByDateId(int $storeId, int $dateId);

    /**
     * 根据dateId修改某个日程的信息
     *
     * @param integer $storeId
     * @param integer $dateId  要修改的日期id，格式要求如：20180803 
     * @param array $data
     * 参数 $data 字段说明：
     * ['offday'] => 是否是休息日，0不是，1是
     * 
     * @return int  成功更新的条数
     */
    public function updateSchedule(int $storeId, int $dateId, array $data);

    /**
     * 添加一个日程安排
     *
     * @param integer $storeId
     * @param integer $dateId  要添加的日期id，格式要求如：20180803 
     * @param array $data
     * 参数 $data 字段说明：
     * ['offday'] => 是否是休息日，0不是，1是
     * 
     * @return int 
     */
    public function addSchedule(int $storeId, int $dateId, array $data);
}