<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

 

namespace Hdll\Services\SMS\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of SMS service
 *
 * @method ResultInterface deferCreateCost(int $storeId,int $sceneId,int $decnum,string $nickname,string $phone)
 * @method ResultInterface deferPayOrder(int $storeId,string $orderSn,int $payStatus) 
 * @method ResultInterface deferGetOrder(int $storeId,int $smsOId)
 * @method ResultInterface deferGetOrderBySn(int $storeId,string $sn)
 * @method ResultInterface deferGetCountLeft(int $storeId)
 */
interface SMSInterface
{ 
    /**
     * 消费短信
     *
     * @param integer $storeId
     * @param int $sceneId
     * @param integer $decnum
     * @param string $nickname
     * @param string $phone
     * @return int
     */
    public function createCost(int $storeId,int $sceneId,int $decnum,string $nickname,string $phone);


    /**
     * 支付短信套餐包订单
     *
     * @param string $orderSn
     * @param integer $payStatus
     * @return int
     */
    public function payOrder(int $storeId,string $orderSn,int $payStatus);

     /**
     * 根据主键获取短信订单
     * @param integer $storeId
     * @param integer $smsOId
     * @return array
     */
    public function getOrder(int $storeId,int $smsOId);

    /**
     * 根据订单编号获取短信订单
     *
     * @param integer $storeId
     * @param string $sn
     * @return array
     */
    public function getOrderBySn(int $storeId,string $sn);


     /**
     * 根据店铺id 获取剩余的短信条数
     *
     * @param integer $storeId
     * @return int
     */
    public function getCountLeft(int $storeId);
    
}
