<?php
namespace Hdll\Services\Common\Lib;

use Flc\Dysms\Client;
use Flc\Dysms\Request\SendSms;


/**
 * 阿里云发送短信工具类
 * 使用： 
 * $alisms = new Alisms(Alisms::SN_01,'SMS_101145139',['code' => $vcode]);
 * 或：
 * $alisms = (new Alisms)->setSignName(Alisms::SN_01)
 *                       ->setTemplateCode(Alisms::TPL_01)
 *                       ->setTemplateParam(['code' => $vcode]);
 * $response = $alisms->send(15825290203);
 */
class Alisms
{
    // 阿里云注册的签名列表：
    // 目前只有一个
    const SN_01 = '活动啦啦'; // 签名1
    
    // 阿里云注册的短信模板列表：
    // 目前只有一个
    const TPL_01 = 'SMS_101145139'; // 模板1

    protected $config;
    protected $templateCode;
    protected $templateParam;
    protected $signName;
    
    public function __construct($signName=null, $templateCode=null, $templateParam=[])
    {
        // 短信签名，示例：活动啦啦
        $this->signName = $signName ?? self::SN_01;
        // 短信模板编号
        $this->templateCode = $templateCode ?? self::TPL_01;
        // 短信模板预设参数
        $this->templateParam = $templateParam;

        $configurator = \Swoft\App::getBean('config');
        $configurator->load('@vendor/hdll/services/src/Common/Config');
        $this->config = $configurator->get('alisms');

    }

    /**
     * 发送短信（发送预设置的短信模板）
     * @param $phone
     * @return mixed
     */
    public function send($phone)
    {
        $client = new Client($this->config);
        $sendSms = new SendSms();
        $sendSms->setPhoneNumbers($phone);
        $sendSms->setSignName($this->signName);
        $sendSms->setTemplateCode($this->templateCode);
        $sendSms->setTemplateParam($this->templateParam);
        $sendSms->setOutId('hdll');

        return $client->execute($sendSms);

    }

    public function setSignName($signName){
        $this->signName = $signName;
        return $this;
    }

    public function setTemplateCode($templateCode){
        $this->templateCode = $templateCode;
        return $this;
    }

    public function setTemplateParam($templateParam){
        $this->templateParam = $templateParam;
        return $this;
    }


}