<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:48
 */

namespace Hdll\Services\BuyerDistribution\Lib;
use Swoft\Core\ResultInterface;


/**
 * @method ResultInterface deferGetSetting(string $token)
 * @method ResultInterface deferPutSetting(string $token,array $param)
 * @method ResultInterface deferGetTeam(string $token,int $pid,int $page)
 * @method ResultInterface deferSaveAgencyBill(string $token,array $order)
 * Interface AgencyInterface
 * @package App\Lib
 */
interface AgencyInterface{

	/**
	 * 获取分销设置
	 * @return mixed
	 * @author Administrator
	 */
	public function getSetting(string $token);

	/**
	 * 写入或更新分销设置
	 * @param array $param
	 * @return mixed
	 * @author Administrator
	 */
	public function putSetting(string $token,array $param);


	/**
	 * 获取团队列表
	 * @param $pid
	 * @param $page
	 * @return mixed
	 * @author Administrator
	 */
	public function getTeam(string $token,int $pid,int $page);

	/**
	 * 保存分销账单
	 * @param array $order 订单数据
	 * @return mixed
	 * @author Administrator
	 */
	public function saveAgencyBill(string $token,array $order);

	/**
	 * 增加卖家冻结金额
	 * @param string $token
	 * @param int    $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addSellerFreezeMoney(string $token,int $money);
}