<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of visitor-count service
 *
 * @method ResultInterface deferUpdateVisitorData(int $storeId, int $visitorId, array $data = [])
 */
interface VisitorCountInterface
{
    /**
     * 根据店铺id和访客id更新一条访客记录
     * 如果已有记录，会替换更新，如果没有，会新建一条记录
     * 
     * @param int $storeId
     * @param int $visitorId
     * @param array $data  此参数可选，不传表示只更新访问时间
     * nickname     昵称
     * headImgUrl   头像
     * @return bool
     */
    public function updateVisitorData(int $storeId, int $visitorId, array $data = []);
    
}