<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/3
 * Time: 17:21
 */
namespace Hdll\Services\Common\Exception;

class ExceptionData
{

    public static function getExceptionData($errData, array $param= [])
    {
        return [
            "code" => $errData['code'],
            "msg" => $errData['msg'],
            "errorCode" => $errData["errCode"],
            "data" => $errData['data'],
            "path" => $errData['path']
        ];
    }


    /**
     * 组装抛出的rpc信息
     * @param \Throwable $e
     * @return array
     */
    public static function getRpcErrData(\Throwable $e)
    {
        //初始化异常数据
        $data = [
            "code" => $e->getCode(),
            "msg" => $e->getMessage(),
            "errCode" => is_callable([$e,'getErrCode'])?$e->getErrcode():'',
            'path' =>[],
        ];
        
        if ( is_callable([$e,"getPath"]) ) {//自建异常类处理path
            $data['path'] = json_decode($e->getPath(), true);

            //获取调用堆栈信息
            $info = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,1)[0];
            //将此次异常信息入站
            array_unshift($data['path'],'Service:'.APP_NAME.' file:'.$info['file'].'('.$info['line'].')');

        } else { //系统异常统一报500错误
            $data['code'] = 500;

            //将此次异常信息入站
            array_unshift($data['path'],'Service:'.APP_NAME.' file:'.$e->getFile().'('.$e->getLine().')');
        }



        return ['msg' => json_encode($data), 'code' => $data['code']];
    }
}