<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store-settings service
 *
 * @method ResultInterface deferGetSettings(int $storeId)
 * @method ResultInterface deferGetNoticeSwitch(int $storeId)
 */
interface SettingsInterface
{
    /**
     * 获取店铺基础设置项
     * 
     * @param int $storeId  
     * @return array
     */
    public function getSettings(int $storeId);

    /**
     * 获取餐饮行业店铺的设置
     * 
     * @Number(name="storeId")
     * @param int $storeId  
     * @return array
     */
    public function getCateringSettings(int $storeId);

    /**
     * 获取消息通知的开关设置项
     * 
     * @param int $storeId  
     * @return array
     * array(5) {
     *   ["pay_notice"]=>             // 付款通知，1表示允许发送通知
     *   int(0)
     *   ["refund_notice"]=>          // 退款通知，1表示允许发送通知
     *   int(1)
     *   ["reserv_notice"]=>          // 预约通知，1表示允许发送通知
     *   int(0)
     *   ["cancel_reserv_notice"]=>   // 取消预约通知，1表示允许发送通知
     *   int(0)
     *   ["delivered_notice"]=>       // 核销通知，1表示允许发送通知
     *   int(1)
     *   ["cancel_order_notice"]=>    // 订单取消的通知，1表示允许发送通知
     *   int(1)
     *   ["withdraw_notice"]=>        // 提现申请的通知，1表示允许发送通知
     *   int(1)
     *   ["grant_comm_notice"]=>      // 下级升级vip产生新的佣金的通知，1表示允许发送通知
     *   int(1)
     * }
     */
    public function getNoticeSwitch(int $storeId);

}