<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Recharge\Lib;

use Hdll\Services\Recharge\Enum\BuyCardPayStatus;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferpayStatus(string $storeId,int $bargainbranchId,int $status,int $orderId)
 * @method  ResultInterface deferspendCardMoney(string $storeId,string $buyerId,int $goodOrderId)
 */
interface RechargeInterface
{
    

    /**
     * 支付 状态 回馈接口
     * @param string $storeId //
     * @param int $itemId // 项目ID $localorderId
     * @param int $status // BuyCardPayStatus::HAVE_PAY 成功支付  BuyCardPayStatus::PAY_EXCEPTION：未支付 （已经过期或者支付异常）
     * @return mixed
     */
    public function payStatus(
        string $storeId,
        int $itemId,
        int $status ,  //
        int $orderId);


    public function spendCardMoney(
        int $storeId,
        int $buyerId,
        int $goodOrderId
    );
}




 