<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Common\Pool\Config;

use Swoft\Bean\Annotation\Bean;
use Swoft\Pool\PoolProperties;
use Swoft\Bean\Annotation\Value;

/**
 * the config of service user
 *
 * @Bean()
 */
class ReservationPoolConfig extends PoolProperties
{

    protected $name = 'reservation';

    /**
     * Minimum active number of connections
     *
     * @var int
     */
    protected $minActive = 5;

    /**
     * the maximum number of active connections
     *
     * @var int
     */
    protected $maxActive = 50;

    /**
     * the maximum number of wait connections
     *
     * @var int
     */
    protected $maxWait = 100;

    /**
     * Maximum waiting time
     *
     * @var int
     */
    protected $maxWaitTime = 3;

    /**
     * Maximum idle time
     *
     * @var int
     */
    protected $maxIdleTime = 60;

    /**
     * the time of connect timeout
     *
     * @var int
     */
    protected $timeout = 5;

    /**
     * the addresses of connection
     *
     * <pre>
     * [
     *  '127.0.0.1:88',
     *  '127.0.0.1:88'
     * ]
     * </pre>
     * @Value(name="", env="${RPC_RESERVATION_URI}")
     * @var array
     */
    protected $uri = ['172.21.0.11:8099','172.16.255.6:8099'];

    /**
     * whether to user provider(consul/etcd/zookeeper)
     *
     * @var bool
     */
    protected $useProvider = false;

    /**
     * the default balancer is random balancer
     *
     * @var string
     */
    protected $balancer = '';

    /**
     * the default provider is consul provider
     *
     * @var string
     */
    protected $provider = '';
}
