<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:49
 */
namespace Hdll\Services\Common\Entity;

use Swoft\App;
use Swoft\Db\Bean\Collector\EntityCollector;
use Swoft\Db\Model;
use Swoft\Exception\Exception;

class CommonEntity extends Model
{

    private static $commentString;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();

        if ( false !== strpos(self::$commentString,"{split}") ) {
            $dbNum = self::getDbNum();
            self::setTableName($dbNum);

        }




        $this->init();

    }

    public function init()
    {

    }

    public static function getDb()
    {
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();

        if ( false !== strpos(self::$commentString,"{split}") ) {
            $dbNum = self::getDbNum();
            self::setTableName($dbNum);

        }

        return new static();
    }

    /**
     * 获取分库表明
     * @throws Exception
     */
    public static function tableName()
    {
        $num = self::getDbNum();
        return self::getTableName().'_'.$num;
    }

    /**
     * 获取数据库id
     * @return int
     * @throws Exception
     */
    private static function getDbNum()
    {
        $user = App::getBean(User::class);

        $store = $user->getStoreId();
        if ( empty($store) ) {
            throw new Exception("店铺id获取失败");
        }

        return  $store % 100;

    }

    /**
     * 设置表名
     * @param $dbNum
     */
    private static function setTableName($dbNum)
    {
        $tableName = self::getTableName();

        EntityCollector::collect(
            static::class,
            new \Swoft\Db\Bean\Annotation\Table(['name' => $tableName.'_'.$dbNum])
        );

    }

    /**
     * 获取原始表名
     * @return string
     */
    private static function getTableName()
    {
        preg_match('/(?<=Table\(name=").*(?="\))/', self::$commentString, $matches);
        return $tableName = isset($matches[0])?$matches[0]:'';
    }
}