<?php
namespace Hdll\Services\Common\Controller;

// use Swoft\Http\Message\Server\Request;

/**
 * 活动啦啦Controller基类
 *
 */
class BaseController
{
    /**
     * 业务层-错误时响应
     *
     * @param integer $errorCode
     * @param string $msg
     * @param mixed $data
     * @return array
     */
    public static function error(int $errorCode, string $msg, $data=null) {
        return [
            'error_code' => $errorCode,
            'msg' => $msg,
            'data' => $data,
        ];
    }

    /**
     * 业务层-正确时响应
     * 
     * @param mixed $data
     * @param string $msg
     * @return void
     */
    public static function success($data, string $msg='') {
        return [
            'data' => $data,
            'msg' => $msg,
            'error_code' => 0,
        ];
    }
}