<?php

namespace Hdll\Services\Buyer\Lib;


/**
 * @method ResultInterface deferGetByUnionId(string $unionId, int $storeId)
 * @method ResultInterface deferUsefulAgent(int $storeId, int $agentId)
 * @method ResultInterface deferGetByOpenId(string $openId, int $storeId)
 * Interface AgentInterface
 * @package Hdll\Services\Buyer\Lib
 */
interface AgentInterface
{
	public function getByUnionId(string $unionId, int $storeId);

	public function getByOpenId(string $openId, int $storeId);

	/**
	 * 代理是否可用
	 * @param int $storeId
	 * @param int $agentId
	 * @return bool
	 */
	public function usefulAgent(int $storeId, int $agentId);


	/**
	 * 创建分销商
	 * @param $buyerId
	 * @param $unionId
	 * @param $openId
	 * @param $storeId
	 * @param $nickname
	 * @param $headimgurl
	 * @return array|mixed
	 * @throws BaseException
	 */
	public function create($param);

}