<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\LimitTimeBuy\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferBackNum(string $token, int $consignee_id, int $limit_id, int $selected_num, int $order_type, int $goods_id, string $reservation_time = '')
 */
interface LimitTimeBuyInterface
{
    /**
     *
     * 补回  未支付 限购活动  库存
     * @param string $token
     * @param int $consignee_id
     * @param int $limit_id
     * @param int $selected_num
     * @param int $order_type
     * @param int $goods_id
     * @param string $reservation_time
     * @return mixed
     */
    public function backNum(
        string $token,
        int $consignee_id,
        int $limit_id,
        int $selected_num,
        int $order_type,
        int $goods_id,
        string $reservation_time);

    /**
     *  获取限时购商品的 商品信息
     * @param int $limit_id
     * @return {
            "name"              名称
            "image"             图片
            "price"             价格
            "activityName"      活动名称
     * }
     */
    public function getLimitGoods(
        int $storeId, int $limitId
    );

    /**
     * 通过商品id  获取是否 有限时购活动
     * @param int $storeId
     * @param int $goodsId
     * @return bool
     *
     */
    public function getLimitInfo(
        int $storeId, int $goodsId
    );





    /**
     * 支付 状态 回馈接口
     * @param string $store_id
     * @param int $limit_id
     * @param int $status   // status :1 成功支付  2：未支付 （已经过期或者支付异常）
     * @return mixed
     */
    public function paystatus(
        string $store_id,
        int $limit_id,
        int $status);
}