<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/25
 * Time: 14:00
 */
namespace Hdll\Services\SellerDistribution\Lib;
use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSaveBill($orderId, $sellerId, $money, $level, $memo = '')
 * @method ResultInterface deferSaveCommission($sellerId, $orderId, $money)
 * Interface SellerDistributionInterface
 * @package App\Lib
 */
interface SellerDistributionInterface{


	/**
	 * 保存账单
	 * @param        $orderId
	 * @param        $sellerId
	 * @param        $money
	 * @param        $level
	 * @param string $memo
	 * @return mixed
	 * @author Administrator
	 */
	public function saveBill($orderId, $sellerId, $money, $level, $memo = '');

	/**
	 * 保存佣金记录
	 * @param $sellerId
	 * @param $orderId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function saveCommission($sellerId, $orderId, $money);
}