<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace App\Exception;

use Swoft\App;
use Swoft\Bean\Annotation\ExceptionHandler;
use Swoft\Bean\Annotation\Handler;
use Swoft\Exception\RuntimeException;
use Exception;
use Swoft\Http\Message\Server\Request;
use Swoft\Http\Message\Server\Response;
use Swoft\Exception\BadMethodCallException;
use Swoft\Exception\ValidatorException;
use Swoft\Http\Server\Exception\BadRequestException;
use Swoft\Http\Server\Exception\RouteNotFoundException;
use App\Exception\TestException;

/**
 * the handler of global exception
 *
 * @ExceptionHandler()
 * @uses      Handler
 * @version   2018年01月14日
 * @author    stelin <phpcrazy@126.com>
 * @copyright Copyright 2010-2016 swoft software
 * @license   PHP Version 7.x {@link http://www.php.net/license/3_0.txt}
 */
class HdllExceptionHandler
{
    /**
     * @Handler(Exception::class)
     *
     * @param Response   $response
     * @param \Throwable $throwable
     *
     * @return Response
     */
    public function handlerException(Response $response, \Throwable $throwable)
    {
        $file      = $throwable->getFile();
        $line      = $throwable->getLine();
        $exception = $throwable->getMessage();
        $code = 500;
        $error_code = 0;
        if($throwable instanceof ValidatorException) {
            $code = 400;
        } else if($throwable instanceof BadRequestException) {
            $code = 400;
        } else if($throwable instanceof RouteNotFoundException) {
            $code = 404;
        } else if(\method_exists($throwable, 'getErrcode')) {
            $code      = $throwable->getCode();
            $error_code = $throwable->getErrcode();
        }

        // $data = ['msg' => $exception, 'file' => $file, 'line' => $line, 'code' => $code, 'error_code'=>$error_code];
        // App::error(json_encode($data));

        $data = ['error_code' => $error_code, 'msg' => $exception, 'data' => null];
        return $response->json($data)->withStatus($code);
    }

}