<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store-commission service
 *
 * @method ResultInterface deferGetCommSetting(int $storeId)
 * @method ResultInterface deferUpdateByStoreId(int $storeId)
 */
interface CommsettingInterface
{
    /**
     * 获取买家分销佣金规则
     * 
     * @Number(name="storeId")
     * @param int $storeId  
     * @return array
     */
    public function getCommSetting(int $storeId);

    /**
     * 根据店铺ID修改买家分销的佣金规则
     *
     * @Number(name="storeId")
     * @param integer $storeId
     * @return array
     */
    public function updateByStoreId(int $storeId);

    
}