<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Common\Entity;

use Swoft\Bean\Annotation\Bean;
use Swoft\Db\Bean\Annotation\Id;
use Swoft\Db\Bean\Annotation\Required;
use Swoft\Db\Bean\Annotation\Table;
use Swoft\Db\Bean\Annotation\Column;
use Swoft\Db\Bean\Annotation\Entity;
use Swoft\Db\Model;
use Swoft\Db\Types;

/**
 * 用户实体
 * @Bean()
 * @uses      User
 * @version   2017年08月23日
 * @author    stelin <phpcrazy@126.com>
 * @copyright Copyright 2010-2016 Swoft software
 * @license   PHP Version 7.x {@link http://www.php.net/license/3_0.txt}
 */
class User
{
    private $id;

    private $nick_name;

    private $store_id;

    private $head_img;

    private $token;



    public function __construct($token='')
    {
        $this->setHeadImg("test");
        $this->setId(1);
        $this->setNickName("zhangsan");
        $this->setStoreId("2");
        $this->setToken($token);

    }

    public function getId()
    {
        return $this->id;
    }

    public function getNickName()
    {
        return $this->nick_name;
    }

    public function getStoreId()
    {
        return $this->store_id;
    }

    public function getHeadImg()
    {
        return $this->head_img;
    }

    public function getToken()
    {
        return $this->token;
    }

    public function setId($value)
    {
        return $this->id = $value;
    }

    public function setNickName($value)
    {
        return $this->nick_name = $value;
    }

    public function setStoreId($value)
    {
        return $this->store_id = $value;
    }

    public function setHeadImg($value)
    {
        return $this->head_img = $value;
    }

    public function setToken($value)
    {
        return $this->token = $value;
    }


}
