<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/23
 * Time: 11:21
 */

namespace Hdll\Services\Common\Lib;

use Hdll\Services\Common\Exception\CommonException;
use Qcloud\Cos\Client;
use Swoft\App;
use Swoft\Core\Config;

class Upload
{

	private $Bucket;
	private $APPID;
	private $SecretId;
	private $SecretKey;
	private $Region;


	public function __construct(array $config = [])
	{
		if (empty($config)) {
			/**@var Config */
			$bConfig = \Swoft\App::getBean('config');
			$bConfig->load('@vendor/hdll/services/src/Common/Config');
			$config = $bConfig->get('qCloud');
		}
		$this->Bucket = $config['Bucket'];
		$this->Region = $config['Region'];
		$this->APPID = $config['APPID'];
		$this->SecretId = $config['SecretId'];
		$this->SecretKey = $config['SecretKey'];
	}

	/**
	 * 腾讯OS
	 * @param string $localPath 本地路径
	 * @param string $name 文件名
	 * @return mixed
	 * @throws CommonException
	 * @author Administrator
	 */
	public function upload($localPath = '', $name = '')
	{
		$cosClient = new Client(
			[
				'region' => $this->Region,
				'credentials' => [
					'secretId' => $this->SecretId,
					'secretKey' => $this->SecretKey,
				]
			]
		);
		try {
			$result = $cosClient->Upload(
				$this->Bucket,
				$name,
				fopen($localPath, 'rb')
			);
		} catch (\Exception $e) {
			throw new CommonException(['msg' => $e->getMessage()]);
		}
		return $result;
	}
}