<?php
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://doc.swoft.org
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */
namespace Swoft\Db;

use Swoft\Core\RequestContext;

/**
 * Query
 */
class Query
{
    /**
     * @param string $tableName
     * @param string $alias
     *
     * @return QueryBuilder
     */
    public static function table(string $tableName, string $alias = null): QueryBuilder
    {
        $query = new QueryBuilder();
        
        $query = $query->table($tableName, $alias);

        return $query;
    }

    private function getTableName($commentString)
    {
        preg_match('/(?<=Table\(name=").*(?="\))/', $commentString, $matches);
        return $tableName = isset($matches[0])?$matches[0]:'';
    }

    private function getDbNum()
    {
        $data = RequestContext::getContextData();
        $storeId = $data['userInfo']['storeId'];
        return $storeId % 100;
    }
}
