<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Shop\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store service
 *
 * @method ResultInterface deferIsCertified(int $storeId)
 */
interface StoreInterface
{
    /**
     * 查询店铺是否已实名认证（企业认证）
     *
     * @param integer $storeId
     * @return boolean
     */
    public function isCertified(int $storeId);

    
}