<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/25
 * Time: 14:00
 */
namespace Hdll\Services\SellerDistribution\Lib;
use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSaveBill($orderId, $sellerId, $money)
 * @method ResultInterface deferGetCommission($sellerId)
 * method ResultInterface deferAddBalance($sellerId, $money)
 * method ResultInterface deferReduceBalance($sellerId, $money)
 * method ResultInterface deferAddTotal($sellerId, $money)
 * method ResultInterface deferReduceTotal($sellerId, $money)
 * method ResultInterface deferListByOrderId($storeId, $orderId,$sellerId)
 * Interface SellerDistributionInterface
 * @package App\Lib
 */
interface SellerDistributionInterface{


	/**
	 * 保存账单
	 * @param        $orderId
	 * @param        $sellerId
	 * @param        $money
	 * @param        $level
	 * @param string $memo
	 * @return mixed
	 * @author Administrator
	 */
	public function saveBill($orderId, $sellerId, $money);


	/**
	 * 获取佣金信息
	 * @param $sellerId
	 * @return mixed
	 * totalCommission  累计佣金
	 * balanceCommission    可提现佣金
	 * @author Administrator
	 */
	public function getCommission($sellerId);

	/**
	 * 增加佣金
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addBalance($sellerId, $money);

	/**
	 * 减少佣金
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceBalance($sellerId, $money);

	/**
	 * 增加累计佣金
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addTotal($sellerId, $money);

	/**
	 * 减少累计佣金
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceTotal($sellerId, $money);

	/**
	 * 获取分销记录
	 * @param $storeId
	 * @param $orderId
	 * @param $sellerId
	 * @return mixed
	 * @author Administrator
	 */
	public function listByOrderId($storeId, $orderId,$sellerId);
}