<?php

namespace Hdll\Services\Common\Config;

use Swoft\Redis\Redis;
use Swoft\App;

class CfgCenter
{
	const COS            = 'cos'; //腾讯云存储
	const CLS            = 'cls'; //腾讯云日志服务
	const CMQ            = 'cmq'; //腾讯云cmq订阅消息
	const ENCRYPT_KEY    = 'encrypt_key'; //数据加密的key
	const BACKEND_WEAPP  = 'backend_weapp'; //蓝猫小程序配置
	const FRONTEND_WEAPP = 'frontend_weapp'; //橙猫小程序配置
	const ALIYUN_SMS     = 'aliyun_sms'; //阿里云短信
	const TENCENT_SMS    = 'tencent_sms'; //腾讯云短信
	const MP             = 'mp'; //公众号-用于H5公众号登录和发送公众号通知
	const MP_CARD        = 'mp_card'; //制作卡券公众号
	const PAY            = 'pay'; //支付配置
	const DRAW_MONEY     = 'draw_money'; //提现配置
	const PAY_KUANYUAN   = 'pay_kuanyuan'; //宽元的支付平台配置
	const PAY_YUNMAI_ISP = 'pay_yunmai_isp'; //云脉的支付服务商配置，用于托管子商户
	const PAY_ZHIMEI     = 'pay_zhimei'; //致美的支付配置
	const SELLER_DISTRIBUTION = 'seller_distribution'; //卖家分销配置
	const MP_ZHIMEI      = 'mp_zhimei'; //致美的公众号配置

	/**
	 * 根据用户token获取配置, 优先使用此方法读取配置
	 * 用法：
	 * $cfgdata = CfgCenter::getByUser(CfgCenter::COS, $this->user);
	 * var_dump($cfgdata['Region']); // 输出：ap-shanghai
	 * @param string $keyName
	 * @param \Hdll\Services\Common\Entity\User $user  用户token的实例对象
	 * @return mixed
	 */
	public static function getByUser($keyName, \Hdll\Services\Common\Entity\User $user)
	{
		if( is_numeric($user->getOemId()) ) { // oemId有可能等于0
			return self::getByOemId($keyName, $user->getOemId());
		} else if($user->getStoreId()) {
			return self::getByStoreId($keyName, $user->getStoreId());
		} else if($user->getUnionid()) {
			return self::getByUnionId($keyName, $user->getUnionid());
		}
	}

	/**
	 * 根据oemId读取指定的配置项 - 返回数组格式
	 * @param string $keyName 
	 * @param int    $oemId oemId==0表示是活动啦啦
	 * @return mixed
	 */
	public static function getByOemId($keyName, int $oemId)
	{
		return self::_get($keyName, $oemId);
	}

	/**
	 * 如果有oemId，尽量使用方法getByOemId()读取配置
	 * 根据storeId获取所属OEM平台的配置
	 *
	 * @param string $keyName
	 * @param string $storeId
	 * @return mixed
	 */
	public static function getByStoreId($keyName, int $storeId)
	{
		$dbConn = self::dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['storeId' => $storeId]);
		return self::_get($keyName, (int)$result['oemId']);
	}

	/**
	 * 如果有oemId，尽量使用方法getByOemId()读取配置
	 * 根据sellerId获取所属OEM平台的配置
	 *
	 * @param string $keyName
	 * @param string $sellerId
	 * @return mixed
	 */
	public static function getBySellerId($keyName, int $sellerId)
	{
		$dbConn = self::dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['sellerId' => $sellerId]);
		return self::_get($keyName, (int)$result['oemId']);
	}

	/**
	 * 如果有oemId，尽量使用方法getByOemId()读取配置
	 * 根据unionId获取所属OEM平台的配置
	 *
	 * @param string $keyName
	 * @param string $unionId
	 * @return mixed
	 */
	public static function getByUnionId($keyName, string $unionId)
	{
		$dbConn = self::dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['unionId' => $unionId]);
		return self::_get($keyName, (int)$result['oemId']);
	}

	/**
	 * 如果有oemId，尽量使用方法getCertByOemId()读取证书
	 * 根据店铺id获取支付证书
	 *
	 * @param integer $storeId
	 * @return array
	 */
	public static function getCertByStoreId($keyName, $storeId) {
		$dbConn = self::dbConnect('seller');
		$result = $dbConn->get("seller", ['oemId'], ['storeId' => $storeId]);
		$oemId = (int)$result['oemId'];
		$dbConn = self::dbConnect();//连接配置库
		// 注意，需要返回oemId字段
		$result = $dbConn->get("config", ['oemId', 'certPem', 'keyPem'], ['oemId' => $oemId, 'name' => $keyName]);
		return $result;
	}
	
	/**
	 * 根据oemId获取支付证书
	 *
	 * @param integer $oemId
	 * @return array
	 */
	public static function getCertByOemId($keyName, int $oemId) {
		$dbConn = self::dbConnect();//连接配置库
		// 注意，需要返回oemId字段
		$result = $dbConn->get("config", ['oemId', 'certPem', 'keyPem'], ['oemId' => $oemId, 'name' => $keyName]);
		return $result;
	}

	/**
	 * 根据mchId获取对应的支付配置
	 *
	 * @param string $mchId
	 * @return mixed
	 */
	public static function getByMchId(int $mchId)
	{
		$dbConn = self::dbConnect();//连接配置库
		$result = $dbConn->get("config", ['value'], ['mchId' => $mchId]);
		$resArr = json_decode($result['value'], true);
		return is_array($resArr) ? $resArr : $result['value'];
	}

	public static function dbConnect($database='')
	{
		if($database == '') {
			$database = 'config_center';
		}
		if (\env('ENVIRONMENT', '') == '') {
			// 返回线上数据库连接
			return new \Medoo\Medoo([
				'database_type' => 'mysql',
				'database_name' => $database,
				'server' => '172.21.0.12',
				'username' => 'configer',
				'password' => 'Cfgsu#2390f*_',
				'charset' => 'utf8'
			]);
		} else {
			// 返回测试数据库连接
			return new \Medoo\Medoo([
				'database_type' => 'mysql',
				'database_name' => $database,
				'server' => '192.168.3.202',
				'username' => 'hdller',
				'password' => 'Hdlltest888',
				'charset' => 'utf8'
			]);
		}
	}

	private static function _get($keyName, int $oemId = 1)
	{
		$prefix = "CONFIG_CENTER:oemid_$oemId:";
		$redis = App::getBean(Redis::class);
		$data = $redis->get($prefix . $keyName);
		if($data) {
			$result = json_decode($data, true);
			return is_array($result) ? $result : $data;
		}
		// 没有缓存则从数据库读取：
		$valArr = self::_getConfigFromDb($keyName, $oemId);
		if ($valArr) { //有内容时进行redis缓存
			if (is_array($valArr)) {
				$valArr['oemId'] = $oemId; //需要将oemId加入配置返回
				$redis->set($prefix . $keyName, json_encode($valArr), 3600);
			} else {
				$redis->set($prefix . $keyName, $valArr, 3600);
			}
		}
		return $valArr;
	}

	private static function _getConfigFromDb($keyName, $oemId)
	{
		$dbConn = self::dbConnect();
		$result = $dbConn->select("config", ['value'], ['oemId' => $oemId, 'name' => $keyName]);
		if (!isset($result[0]['value'])) {
			if($oemId > 0) {
				// 如果指定的oemId查找不到，则使用活动啦啦(oemId==0且common==1)的配置
				$result = $dbConn->select("config", ['value'], ['oemId' => 0, 'common' => 1, 'name' => $keyName]);
				if (!isset($result[0]['value'])) {
					return;
				}
			} else {
				return;
			}
		}
		$valArr = json_decode($result[0]['value'], true);
		if (!is_array($valArr)) {
			return $result[0]['value'];
		}
		return $valArr;
	}


}

