<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\TimesCard\Lib;

use Hdll\Services\Recharge\Enum\BuyCardPayStatus;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferpayStatus(int $storeId,int $bargainbranchId,int $status,int $orderId)
 * @method  ResultInterface deferspendTimesCard( int $storeId,int $buyerId,int $itemOrderId, int $usercardId,int $goodsId,string $itemTitle,  int $times)
 * @method  ResultInterface deferReturnCardTimes( int $storeId,int $buyerId,int $itemOrderId,int $goodsId,string $itemTitle,int    $times)
 */
interface TimesCardInterface
{


    /**
     * 微信支付 状态 回馈接口
     * @param string $storeId //
     * @param int $itemId // 项目ID $localorderId
     * @param int $status // BuyCardPayStatus::HAVE_PAY 成功支付  BuyCardPayStatus::PAY_EXCEPTION：未支付 （已经过期或者支付异常）
     * @return mixed
     */
    public function payStatus(
        int $storeId,
        int $itemId,
        int $status ,  //
        int $orderId);

    /**
     * 花费卡次数

     * @param int $storeId          // 商铺id
     * @param int $buyerId          // 买家ID
     * @param int $itemOrderId      // 订单 id
     * @param int $usercardId      // 用户卡id
     * @param int $goodsId     // 商品id
     * @param string $itemTitle   //商品名字
     * @param int $times   // 花费次数  传 1
     * @return mixed
     */
    public function spendTimesCard(
        int $storeId,
        int $buyerId,
        int $itemOrderId,
        int $usercardId,
        int $goodsId,
        string $itemTitle,
        int $times
    );

    /**
     * 退回次卡数量
     * @param int $storeId
     * @param int $buyerId
     * @param int $itemOrderId
     * @param string $itemTitle
     * @param int $payMoney
     * @return mixed
     */
    public function ReturnCardTimes(
        int $storeId,
        int $buyerId,
        int $itemOrderId,
        int $goodsId,
        string $itemTitle,
        int $times
    );
}




 